/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence;

import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.game.constants.FDDMode;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Genre;
import info.msxlaunchers.openmsx.launcher.data.game.constants.InputDevice;
import info.msxlaunchers.openmsx.launcher.persistence.AbstractDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.DatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class TransactionalDatabaseOperation<E>
extends AbstractDatabaseOperation<E> {
    private static final String DUPLICATE_ERROR_CODE = "23505";
    private static final int MAXIMUM_GAME_NAME_LENGTH = 128;

    @Override
    public DatabaseResponse<E> executeOperation(Connection connection) throws LauncherPersistenceException {
        this.beginTransaction(connection);
        DatabaseResponse<E> response = this.executeTransactionalOperation(connection);
        this.commitTransaction(connection);
        return response;
    }

    public abstract DatabaseResponse<E> executeTransactionalOperation(Connection var1) throws LauncherPersistenceException;

    protected boolean isDuplicateError(SQLException se) {
        return se.getSQLState().equals(DUPLICATE_ERROR_CODE);
    }

    protected void setGameStatementFields(PreparedStatement statement, Game game, long databaseId) throws SQLException {
        statement.setString(1, game.getName().substring(0, Math.min(game.getName().length(), 128)));
        statement.setString(2, game.getInfo());
        statement.setString(3, game.getMachine());
        statement.setString(4, game.getRomA());
        statement.setString(5, game.getExtensionRom());
        statement.setString(6, game.getRomB());
        statement.setString(7, game.getDiskA());
        statement.setString(8, game.getDiskB());
        statement.setString(9, game.getTape());
        statement.setString(10, game.getHarddisk());
        statement.setString(11, game.getLaserdisc());
        statement.setString(12, game.getTclScript());
        statement.setBoolean(13, game.isMSX());
        statement.setBoolean(14, game.isMSX2());
        statement.setBoolean(15, game.isMSX2Plus());
        statement.setBoolean(16, game.isTurboR());
        statement.setBoolean(17, game.isPSG());
        statement.setBoolean(18, game.isSCC());
        statement.setBoolean(19, game.isSCCI());
        statement.setBoolean(20, game.isPCM());
        statement.setBoolean(21, game.isMSXMUSIC());
        statement.setBoolean(22, game.isMSXAUDIO());
        statement.setBoolean(23, game.isMoonsound());
        statement.setBoolean(24, game.isMIDI());
        statement.setInt(25, this.getGenreEnumValue(game.getGenre1()));
        statement.setInt(26, this.getGenreEnumValue(game.getGenre2()));
        statement.setInt(27, game.getMsxGenID());
        statement.setString(28, game.getScreenshotSuffix());
        statement.setString(29, game.getSha1Code());
        statement.setLong(30, game.getSize());
        statement.setLong(31, databaseId);
        statement.setShort(32, this.getFDDModeEnumValue(game.getFDDMode()));
        statement.setBoolean(33, game.isTclScriptOverride());
        statement.setShort(34, this.getInputDeviceEnumValue(game.getInputDevice()));
        statement.setBoolean(35, game.isConnectGFX9000());
    }

    protected int getGenreEnumValue(Genre genre) {
        int value = 0;
        if (genre != null) {
            value = genre.getValue();
        }
        return value;
    }

    protected short getFDDModeEnumValue(FDDMode fddMode) {
        short value = 0;
        if (fddMode != null) {
            value = (short)fddMode.getValue();
        }
        return value;
    }

    protected short getInputDeviceEnumValue(InputDevice inputDevice) {
        short value = 0;
        if (inputDevice != null) {
            value = (short)inputDevice.getValue();
        }
        return value;
    }

    private void beginTransaction(Connection connection) throws LauncherPersistenceException {
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException se) {
            throw new LauncherPersistenceException();
        }
    }

    private void commitTransaction(Connection connection) throws LauncherPersistenceException {
        try {
            connection.commit();
        }
        catch (SQLException se) {
            throw new LauncherPersistenceException();
        }
    }
}

